#include "Adafruit_GFX.h"   // Core graphics library
#include "MCUFRIEND_kbv.h"   // Hardware-specific library
MCUFRIEND_kbv tft;

#include "Fonts/FreeSans9pt7b.h"
#include "Fonts/FreeSans12pt7b.h"
#include "Fonts/FreeSerif12pt7b.h"
#include "FreeDefaultFonts.h"

#define BLACK 0x0000
#define BLUE 0x001F
#define RED 0xF800
#define GREEN 0x07E0
#define CYAN 0x07FF
#define MAGENTA 0xF81F
#define YELLOW 0xFFE0
#define WHITE 0xFFFF


void showmsgXY(int x, int y, int sz, const GFXfont *f, const char *msg)
{
  int16_t x1, y1;
  uint16_t wid, ht;
  tft.setFont(f);
  tft.setCursor(x, y);
  tft.setTextSize(sz);
  tft.println(msg);
}

uint8_t r = 255, g = 255, b = 255;
uint16_t color;
String comma_string;


void setup()
{
  Serial1.begin(9600);
  uint16_t ID = tft.readID();
  tft.begin(ID);
  tft.invertDisplay(true);
  tft.setRotation(1);

  tft.invertDisplay(true);
  tft.fillScreen(WHITE);

  color = tft.color565(40, 40, 40);
  tft.setTextColor(color);
  showmsgXY(50, 40, 1, &FreeSerif12pt7b, "Welcome:,"); delay(40);
  tft.println("      to Serial Monitor");
  delay(2000);

}

void loop(void)
{
  while (Serial1.available() == 0) {}
  comma_string = Serial1.readString();

  tft.invertDisplay(true);
  tft.fillScreen(WHITE);

  color = tft.color565(40, 40, 40);
  tft.setTextColor(color);
  showmsgXY(50, 40, 1, &FreeSerif12pt7b, "new message:,"); delay(40);
  tft.println(comma_string);
}
